package gov.va.vamf.scheduling.varutility.mhp;

import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MhpObjectFactory implements ApplicationContextAware {
    private static final Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MhpObjectFactory.class);

    private static MhpObjectFactory instance = null;
    private static ApplicationContext springContext = null;

    public MhpObjectFactory() {
        LOGGER.debug("invoked default constructor");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        springContext = applicationContext;
    }

    public static MhpObjectFactory getInstance() {
        if (instance == null) {
            initializeInstance();
        }
        return instance;
    }

    private synchronized static void initializeInstance() {
        if (instance == null) {
            LOGGER.debug("initalizing mhp object factory");
            instance = new MhpObjectFactory();
        }
    }

    @SuppressWarnings("unchecked")
    public <T> T getBean(String beanName) {
        T bean = (T) springContext.getBean(beanName);
        LOGGER.debug(String.format("loaded bean (without type safety) [beanname='%s']=>[bean=%s]", beanName, bean));
        return bean;
    }

    public <T> T getBean(String beanName, Class<T> requiredType) {
        T bean = (T)springContext.getBean(beanName, requiredType);
        LOGGER.debug(String.format("loaded bean (with type safety) [beanname='%s']=>[bean=%s]", beanName, bean));
        return bean;
    }
}
